# System Architecture Diagram

## Complete System Flow

```mermaid
graph TB
    subgraph "ESP8266 Device"
        ESP[ESP8266 NodeMCU]
        RTC[DS3231 RTC Module]
        R1[Relay 1 - D0]
        R2[Relay 2 - D5]
        R3[Relay 3 - D6]
        R4[Relay 4 - D7]
        R5[Relay 5 - D4]
        
        ESP --> RTC
        ESP --> R1
        ESP --> R2
        ESP --> R3
        ESP --> R4
        ESP --> R5
    end
    
    subgraph "MQTT Communication"
        BROKER[MQTT Broker<br/>49.207.44.7:1883]
        PUB_STATUS[Publish: relay/status/0-4]
        SUB_MODE[Subscribe: relay/set_mode]
        SUB_RTC[Subscribe: rtc/set]
    end
    
    subgraph "Node-RED Server"
        FLOW[Node-RED Flow]
        STORAGE[Flow Context Storage]
        API_STATUS[GET /api/relays/status]
        API_MODE[POST /api/relays/mode]
        API_ROUTINES[POST /api/relays/routines]
        API_RTC[POST /api/rtc/sync]
        
        FLOW --> STORAGE
        FLOW --> API_STATUS
        FLOW --> API_MODE
        FLOW --> API_ROUTINES
        FLOW --> API_RTC
    end
    
    subgraph "Web Dashboard"
        HTML[dashboard.html]
        CSS[styles.css]
        JS[app.js]
        BROWSER[Web Browser]
        
        HTML --> CSS
        HTML --> JS
        BROWSER --> HTML
    end
    
    ESP -->|Publish Status<br/>Every 2 min| PUB_STATUS
    PUB_STATUS --> BROKER
    BROKER --> FLOW
    
    FLOW -->|Commands| SUB_MODE
    FLOW -->|Time Sync| SUB_RTC
    SUB_MODE --> BROKER
    SUB_RTC --> BROKER
    BROKER -->|Subscribe| ESP
    
    BROWSER -->|HTTP Requests| API_STATUS
    BROWSER -->|HTTP Requests| API_MODE
    BROWSER -->|HTTP Requests| API_ROUTINES
    BROWSER -->|HTTP Requests| API_RTC
    
    API_STATUS -->|JSON Response| BROWSER
    API_MODE -->|JSON Response| BROWSER
    API_ROUTINES -->|JSON Response| BROWSER
    API_RTC -->|JSON Response| BROWSER
    
    style ESP fill:#4CAF50,color:#fff
    style BROKER fill:#FF9800,color:#fff
    style FLOW fill:#2196F3,color:#fff
    style BROWSER fill:#9C27B0,color:#fff
```

## Data Flow Sequence

```mermaid
sequenceDiagram
    participant ESP as ESP8266
    participant MQTT as MQTT Broker
    participant NR as Node-RED
    participant DB as Web Dashboard
    participant User as User
    
    Note over ESP,User: System Startup
    ESP->>MQTT: Connect & Subscribe to topics
    NR->>MQTT: Connect & Subscribe
    DB->>NR: GET /api/relays/status
    NR->>DB: Return cached status
    
    Note over ESP,User: Status Publishing (Every 2 min)
    loop Every 2 minutes per relay
        ESP->>MQTT: Publish relay/status/0-4
        MQTT->>NR: Forward status message
        NR->>NR: Store in flow context
    end
    
    Note over ESP,User: Dashboard Polling (Every 5 sec)
    loop Every 5 seconds
        DB->>NR: GET /api/relays/status
        NR->>DB: Return current status
        DB->>DB: Update UI
    end
    
    Note over ESP,User: User Control Action
    User->>DB: Click "Manual ON" button
    DB->>NR: POST /api/relays/mode {relay:0, mode:"manual_on"}
    NR->>NR: Update local storage
    NR->>MQTT: Publish relay/set_mode
    MQTT->>ESP: Forward command
    ESP->>ESP: Change relay state
    ESP->>MQTT: Publish updated status
    MQTT->>NR: Forward status
    NR->>NR: Update storage
    DB->>NR: GET /api/relays/status
    NR->>DB: Return updated status
    DB->>User: Show relay is ON
```

## Component Interaction

```mermaid
graph LR
    subgraph Input
        USER[User Input]
        TIME[RTC Time]
        ROUTINE[Scheduled Routines]
    end
    
    subgraph Processing
        AUTO[Auto Mode Logic]
        MANUAL[Manual Override]
        MQTT_PROC[MQTT Processing]
    end
    
    subgraph Output
        RELAY[Relay Control]
        STATUS[Status Updates]
        STORAGE[Persistent Storage]
    end
    
    USER --> MANUAL
    TIME --> AUTO
    ROUTINE --> AUTO
    
    AUTO --> RELAY
    MANUAL --> RELAY
    MQTT_PROC --> MANUAL
    
    RELAY --> STATUS
    RELAY --> STORAGE
    STATUS --> MQTT_PROC
    
    style USER fill:#E91E63,color:#fff
    style RELAY fill:#4CAF50,color:#fff
    style STORAGE fill:#FF9800,color:#fff
```

## Network Topology

```mermaid
graph TB
    subgraph "Internet"
        USER_DEVICE[User Device<br/>Laptop/Phone]
    end
    
    subgraph "Cloud Server"
        NR_SERVER[Node-RED Server<br/>sensorsnodered.kalpatech.co.in]
        MQTT_SERVER[MQTT Broker<br/>49.207.44.7:1883]
    end
    
    subgraph "Local Network"
        ROUTER[WiFi Router<br/>2.4 GHz]
        ESP_DEVICE[ESP8266<br/>Relay Controller]
    end
    
    USER_DEVICE -->|HTTPS| NR_SERVER
    ESP_DEVICE -->|MQTT| MQTT_SERVER
    NR_SERVER -->|MQTT| MQTT_SERVER
    ROUTER --> ESP_DEVICE
    
    style USER_DEVICE fill:#2196F3,color:#fff
    style NR_SERVER fill:#4CAF50,color:#fff
    style MQTT_SERVER fill:#FF9800,color:#fff
    style ESP_DEVICE fill:#9C27B0,color:#fff
```

## State Machine - Relay Operation

```mermaid
stateDiagram-v2
    [*] --> PowerOn
    PowerOn --> Initializing
    
    Initializing --> ConnectingWiFi
    ConnectingWiFi --> WiFiConnected: Success
    ConnectingWiFi --> APMode: Failed
    
    WiFiConnected --> ConnectingMQTT
    ConnectingMQTT --> MQTTConnected: Success
    ConnectingMQTT --> Standalone: Failed
    
    MQTTConnected --> AutoMode
    Standalone --> AutoMode
    APMode --> AutoMode
    
    state OperationMode {
        AutoMode --> CheckRoutines
        CheckRoutines --> RelayOn: Time Match
        CheckRoutines --> RelayOff: No Match
        
        RelayOn --> CheckRoutines: Loop
        RelayOff --> CheckRoutines: Loop
        
        AutoMode --> ManualOn: User Command
        AutoMode --> ManualOff: User Command
        
        ManualOn --> AutoMode: User Command
        ManualOff --> AutoMode: User Command
    }
    
    OperationMode --> PublishStatus: Every 2 min
    PublishStatus --> OperationMode
    
    OperationMode --> [*]: Power Off
```

## Data Structure

```mermaid
classDiagram
    class RelayData {
        +Array relays
        +RTC rtc
    }
    
    class Relay {
        +int relay
        +boolean state
        +string mode
        +Array routines
    }
    
    class Routine {
        +string on
        +string off
        +boolean enabled
    }
    
    class RTC {
        +string date
        +string time
    }
    
    RelayData "1" --> "5" Relay
    Relay "1" --> "*" Routine
    RelayData "1" --> "1" RTC
```

## File Structure

```
Project Root
│
├── ESP8266 Code
│   └── Esp8266_Enhanced_FIXED.ino
│
├── Web Dashboard
│   ├── dashboard.html          (Main UI)
│   ├── styles.css              (Styling)
│   └── app.js                  (Logic & API calls)
│
├── Node-RED
│   └── nodered-flow.json       (Complete flow)
│
└── Documentation
    ├── SETUP_GUIDE.md          (Full setup instructions)
    ├── QUICK_REFERENCE.md      (Quick reference card)
    └── ARCHITECTURE.md         (This file)
```

## Technology Stack

```mermaid
graph LR
    subgraph Frontend
        HTML5[HTML5]
        CSS3[CSS3]
        JS[JavaScript ES6]
        BS[Bootstrap 5.3]
        BI[Bootstrap Icons]
    end
    
    subgraph Backend
        NR_RUNTIME[Node-RED Runtime]
        MQTT_LIB[PubSubClient]
        JSON_LIB[ArduinoJson]
    end
    
    subgraph Hardware
        ESP_CHIP[ESP8266]
        RTC_CHIP[DS3231]
        RELAY_MOD[5CH Relay Module]
    end
    
    subgraph Protocols
        HTTP_PROTO[HTTP/REST]
        MQTT_PROTO[MQTT]
        I2C_PROTO[I2C]
    end
    
    HTML5 --> HTTP_PROTO
    JS --> HTTP_PROTO
    NR_RUNTIME --> HTTP_PROTO
    NR_RUNTIME --> MQTT_PROTO
    ESP_CHIP --> MQTT_PROTO
    ESP_CHIP --> I2C_PROTO
    RTC_CHIP --> I2C_PROTO
    
    style Frontend fill:#2196F3,color:#fff
    style Backend fill:#4CAF50,color:#fff
    style Hardware fill:#FF9800,color:#fff
    style Protocols fill:#9C27B0,color:#fff
```

## Security Layers

```mermaid
graph TB
    subgraph "Security Measures"
        AUTH[Authentication]
        ENCRYPT[Encryption]
        ACCESS[Access Control]
        FIREWALL[Firewall Rules]
    end
    
    subgraph "Implementation"
        MQTT_AUTH[MQTT User/Pass]
        WIFI_PSK[WiFi Password]
        AP_PSK[Hotspot Password]
        CORS[CORS Headers]
    end
    
    AUTH --> MQTT_AUTH
    AUTH --> WIFI_PSK
    AUTH --> AP_PSK
    ACCESS --> CORS
    
    style AUTH fill:#E91E63,color:#fff
    style ENCRYPT fill:#FF9800,color:#fff
    style MQTT_AUTH fill:#4CAF50,color:#fff
```
